//
// module controls the AD9508 clock chip on the COLUTA tester board
// and Bunch crossing signal generation
//
// v1.0 jb/august/2018
//
//
//***************************************************************************
//
//  FC control register definition:
//
//  FC_cntrl   [0] RSTB  signal enable
//  FC_cntrl   [1] I2C_mux control (if 1'1b1 also FC function enable)
//
//  FC_cntrl[111:8] SCL_bit wave
//  FC_cntrl[205:112] SDA_outp_en
//  FC_cntrl[319:216] SDA_bit wave
//
//  RSTB, SYNCB operations are very sensitive,
//  generate only one signal at the time !!!
//
//***************************************************************************
//

module False_conditions
    (  
          //module state machine inputs
          input clk,
          input rst,
          input op_start,
          input wire[319:0] FC_cntrl,
		  
		  
          //I2C signals
          output  SCL_FC,
          output  SDA_FC,
          output  SDA_FC_o,
			 
          //i2C signl mux control
          output reg I2C_mux

    );
		


//variables			
reg        op_starts, op_start_reg, rst_reg, rst_flg, op_in_progress; 
reg [103:0] SCL_wave, SDA_outp_en, SDA_wave;
reg  [7:0] bit_count;

//main body
always @(posedge clk)	
 begin	
//operation starts
        op_start_reg <= op_start;
        op_starts    <= ~op_start_reg & op_start;
//reset flag
        rst_reg <= rst;
        rst_flg <= ~rst_reg & rst;
 end
 
 always @(posedge clk)	
 begin
       if (rst_flg)        
		  begin
             bit_count   <= 8'b01101000; 		//number of bits 104 
		     I2C_mux     <= 1'b0;
			 SCL_wave    <= {104{1'b0}};
			 SDA_outp_en <= {104{1'b0}};
			 SDA_wave    <= {104{1'b0}};
			 
			 op_in_progress <= 1'b0;
		  end
       else 
		  if (op_starts) 
		   begin
             bit_count   <= 8'b01101000; 		//number of bits 104 			
		     I2C_mux     <= FC_cntrl [1];
			 SCL_wave    <= FC_cntrl[111:8];
			 SDA_outp_en <= FC_cntrl[215:112];
			 SDA_wave    <= FC_cntrl[319:216];			 
			 op_in_progress <= FC_cntrl [1];
			 
		   end
		 else if (op_in_progress & (bit_count>8'b00000001))    bit_count  <= bit_count - 8'b00000001;
		 else if (op_in_progress & (bit_count==8'b0000001))op_in_progress <= 1'b0; 
		 
		 
       if (op_in_progress)
		  begin
		    SCL_wave[103:1] <= SCL_wave[102:0];
			    SCL_wave[0] <= 1'b1;
		    SDA_outp_en[103:1] <= SDA_outp_en[102:0];
			    SDA_outp_en[0] <= 1'b0;		     
		    SDA_wave[103:1] <= SDA_wave[102:0];
			    SDA_wave[0] <= 1'b1;
		  end
		  
		 
		  if (op_in_progress & (bit_count==8'b00000001))
		  begin
		   I2C_mux <= 1'b0;
		   bit_count <= 8'h00;
		  end
		 
 end
          assign  SCL_FC   = SCL_wave[103];
          assign  SDA_FC   = SDA_wave[103];
          assign  SDA_FC_o = SDA_outp_en[103];
 
endmodule				