#jb/2020

##
## DEVICE  "EP4CGX50CF23C6"
##



#**************************************************************
# Time Information
#**************************************************************

set_time_format -unit ns -decimal_places 3

#**************************************************************
# Create Clocks
#**************************************************************
#create_clock -name {FPGA_CLK} -period  25.000 -waveform { 0.75  13.25 } [get_ports {FPGA_CLK}]
create_clock -name {FPGA_CLK} -period  25.000 -waveform { 1.10  13.6} [get_ports {FPGA_CLK}]

#create manualy latch clock from PLL output
# possible phases/offsets
#
#22.5  45.0  67.5  90.0  112.5   135.0  157.5  180.0 degrees
# 0.19  0.39  0.58  0.78   0.97    1.17   1.36   1.56  1.75  1.95 2.14 ns
#create internal FPGA latch clock
#

#specify offsets
#"data offset" must be experimentaly established!!!
# Routes for 
#          (0.78 0.78 0) 347MHz
#          (0.97 0.58 0) 378MHz
#          (1.17 0.78 0) 378MHz
#          (1.36 0.97 0) 387MHz
#
#********use the following parameters for compiation of different channels to be histogrammed*********
#                 FPGA_CLK                                                                           *
#      channel    waveform      set data_offset1  set data_offset2    code line 1000                 *
#         1      0.800  13.300       1.17              1.56              adc_d_1                     *
#       fr1		  0.750  13.250       1.17              1.36              adc_frame1                  *
#         2      0.800  13.300       1.17              1.36              adc_d_2                     *
#         3      0.800  13.300       1.17              1.56              adc_d_3                     *
#         4      0.850  13.350       1.17              1.36              adc_d_4                     *
#         5      0.800  13.300       1.17              1.56              adc_d_5                     *
#         6      0.800  13.300       1.17              1.56              adc_d_6                     *
#         7      0.800  13.300       1.17              1.56              adc_d_7                     *
#         8      0.800  13.300       1.17              1.56              adc_d_8                     *
#       fr8      0.750  13.250       1.17              1.36              adc_frame8                  *
#*****************************************************************************************************
#       fr8 is compiled with additionsl registers (see the code line 1002) 
#       remove line 1002 from the code if you want to use the table above (for ch1-to-ch8 and frame1)

set data_offset1  0.78
set data_offset2  1.17

#these two offsets stay at '0'
set CP160_offset  0
set fpga_offset   0

#offset for AD9650 chip
#this is a parameter to be experimentaly established !!!
set AD9650_offset 13.5

#make sure clk_320MHz_coluta rising edge is after clk_160MHz_dp_hist !!!!
#create_generated_clock -name clk_320MHz_coluta1 -source [get_pins {pll_1|altpll_component|auto_generated|pll1|inclk[0]}] \
-offset      $data_offset1  \
-duty_cycle  50/1          \
-multiply_by 8             \
-master_clock {pll_0|altpll_component|auto_generated|pll1|clk[0]} [get_pins {pll_1|altpll_component|auto_generated|pll1|clk[1]}] \

#create_generated_clock -name clk_320MHz_coluta2 -source [get_pins {pll_1|altpll_component|auto_generated|pll1|inclk[0]}] \
-offset      $data_offset2  \
-duty_cycle  50/1          \
-multiply_by 8             \
-master_clock {pll_0|altpll_component|auto_generated|pll1|clk[0]} [get_pins {pll_1|altpll_component|auto_generated|pll1|clk[2]}] \


#
#COLUTA serializer data output description
#
#Create the associated virtual COLUTA clock
#
#The setting below is for an "ideal" COLUTA V3 chip 
#create_clock -name COLUTA_VIRT_CLK -period 3.125 -waveform { 0  1.5625 }
#
#If you would need to change data_offset1 or data_offset2 parameter
#due to the very different chip you will need to change its virtual clock
#to different value from the nominal one 
#
#create_clock -name COLUTA_VIRT_CLK -period 1.562  -waveform {0 0.781}
create_clock -name COLUTA_VIRT_CLK -period 3.125 -waveform { 0.000  1.562 }

#set_input_delay -clock COLUTA_VIRT_CLK -max -rise 0.05 [get_ports {DATA1 DATA2 DATA3 DATA4 DATA5 DATA6 DATA7 DATA8 FRAME1 FRAME8}]
#set_input_delay -clock COLUTA_VIRT_CLK -max -fall 0.05 [get_ports {DATA1 DATA2 DATA3 DATA4 DATA5 DATA6 DATA7 DATA8 FRAME1 FRAME8}]
#set_input_delay -clock COLUTA_VIRT_CLK -min -rise 0.05 [get_ports {DATA1 DATA2 DATA3 DATA4 DATA5 DATA6 DATA7 DATA8 FRAME1 FRAME8}]
#set_input_delay -clock COLUTA_VIRT_CLK -min -fall 0.05 [get_ports {DATA1 DATA2 DATA3 DATA4 DATA5 DATA6 DATA7 DATA8 FRAME1 FRAME8}]

#set_input_delay -clock COLUTA_VIRT_CLK -clock_fall -max -rise 0.08 [get_ports {DATA1 DATA2 DATA3 DATA4 DATA5 DATA6 DATA7 DATA8 FRAME1 FRAME8}] -add_delay
#set_input_delay -clock COLUTA_VIRT_CLK -clock_fall -max -fall 0.08 [get_ports {DATA1 DATA2 DATA3 DATA4 DATA5 DATA6 DATA7 DATA8 FRAME1 FRAME8}] -add_delay
#set_input_delay -clock COLUTA_VIRT_CLK -clock_fall -min -rise 0.08 [get_ports {DATA1 DATA2 DATA3 DATA4 DATA5 DATA6 DATA7 DATA8 FRAME1 FRAME8}] -add_delay
#set_input_delay -clock COLUTA_VIRT_CLK -clock_fall -min -fall 0.08 [get_ports {DATA1 DATA2 DATA3 DATA4 DATA5 DATA6 DATA7 DATA8 FRAME1 FRAME8}] -add_delay

#The same-Edge Capture Centre-Aligned Input
#Use false path exceptions to prevent timing analysis "an433.pdf page:16 figur:25"
#on same-edge transfers.
#set_false_path -hold  -rise_from [get_clocks COLUTA_VIRT_CLK] -rise_to [get_clocks clk_320MHz_coluta1]
#set_false_path -hold  -fall_from [get_clocks COLUTA_VIRT_CLK] -fall_to [get_clocks clk_320MHz_coluta1]
#set_false_path -setup -fall_from [get_clocks COLUTA_VIRT_CLK] -rise_to [get_clocks clk_320MHz_coluta1]
#set_false_path -setup -rise_from [get_clocks COLUTA_VIRT_CLK] -fall_to [get_clocks clk_320MHz_coluta1]

#set_false_path -hold  -rise_from [get_clocks COLUTA_VIRT_CLK] -rise_to [get_clocks clk_320MHz_coluta2]
#set_false_path -hold  -fall_from [get_clocks COLUTA_VIRT_CLK] -fall_to [get_clocks clk_320MHz_coluta2]
#set_false_path -setup -fall_from [get_clocks COLUTA_VIRT_CLK] -rise_to [get_clocks clk_320MHz_coluta2]
#set_false_path -setup -rise_from [get_clocks COLUTA_VIRT_CLK] -fall_to [get_clocks clk_320MHz_coluta2]


#************************************************************************
#                      Create generated clocks
#************************************************************************

#40MHz clock for AD9650
#create_generated_clock -name clk_40MHz_ad9650 \
-source [get_pins {pll_1|altpll_component|auto_generated|pll1|inclk[0]}] \
-offset      $AD9650_offset \
-duty_cycle  50/1           \
-multiply_by 1              \
-master_clock {pll_0|altpll_component|auto_generated|pll1|clk[0]} [get_pins {pll_1|altpll_component|auto_generated|pll1|clk[0]}] 

#160MHz dual port memory and histogramming clock
#-offset      $CP160_offset
#create_generated_clock -name clk_160MHz_dp_hist \
-source [get_pins {pll_1|altpll_component|auto_generated|pll1|inclk[0]}] \
-offset      $CP160_offset \
-duty_cycle  50/1          \
-multiply_by 4             \
-master_clock {pll_0|altpll_component|auto_generated|pll1|clk[0]} [get_pins {pll_1|altpll_component|auto_generated|pll1|clk[3]}] 

#CLK40 clock
create_generated_clock -name clk40 -source [get_pins {pll_0|altpll_component|auto_generated|pll1|inclk[0]}] \
-offset      $fpga_offset  \
-duty_cycle  50/1          \
-multiply_by 1             \
-master_clock {FPGA_CLK} [get_pins {pll_0|altpll_component|auto_generated|pll1|clk[1]}] 


#5MHz clock
create_generated_clock -name clk5_int -source [get_pins {pll_0|altpll_component|auto_generated|pll1|inclk[0]}] \
-offset      $fpga_offset  \
-duty_cycle  50/1          \
-multiply_by 1             \
-divide_by   8             \
-master_clock {FPGA_CLK} [get_pins {pll_0|altpll_component|auto_generated|pll1|clk[2]}] 


#320MHz clock for trigger
create_generated_clock -name clk320_trigger -source [get_pins {pll_0|altpll_component|auto_generated|pll1|inclk[0]}] \
-offset      $fpga_offset  \
-duty_cycle  50/1          \
-multiply_by 8             \
-master_clock {FPGA_CLK} [get_pins {pll_0|altpll_component|auto_generated|pll1|clk[3]}] 

#DAC_SCLK clock
#create_generated_clock -name DAC_SCLK -source [get_pins {pll_0|altpll_component|auto_generated|pll1|clk[1]}] \
-master_clock {clk40} [get_nets {dac1|DAC_SCLK}] 

#ADC121 SCLK clock
#create_generated_clock -name ADC121_SCLK -source [get_pins {pll_0|altpll_component|auto_generated|pll1|clk[1]}] \
-master_clock {clk40} [get_nets {dos1|SCLK}] 

#
#AD9650 data description
#
#create_clock -name {DCOA} -period  25.000  [get_ports {DCOA}]
#create_clock -name {DCOB} -period  25.000  [get_ports {DCOB}]

#set_clock_latency -source $AD9650_offset [get_clocks {DCOA}]
#set_clock_latency -source $AD9650_offset [get_clocks {DCOB}]

#set_input_delay -clock { clk_40MHz_ad9650 } -rise -max  2 [get_ports DA\[*\]]
#set_input_delay -clock { clk_40MHz_ad9650 } -rise -min  2 [get_ports DA\[*\]] 
#set_input_delay -clock { clk_40MHz_ad9650 } -fall -max  2 [get_ports DA\[*\]] 
#set_input_delay -clock { clk_40MHz_ad9650 } -fall -min  2 [get_ports DA\[*\]] 

#set_input_delay -clock { clk_40MHz_ad9650 } -rise -max  2 [get_ports DB\[*\]]
#set_input_delay -clock { clk_40MHz_ad9650 } -rise -min  2 [get_ports DB\[*\]] 
#set_input_delay -clock { clk_40MHz_ad9650 } -fall -max  2 [get_ports DB\[*\]] 
#set_input_delay -clock { clk_40MHz_ad9650 } -fall -min  2 [get_ports DB\[*\]] 


#AD9650 data output offset
#set AD9650_output_offset1   0
#set AD9650_output_offset2   0

#DCOA_clk
#create_generated_clock -name DCOA_clk -source [get_pins {pll_2|altpll_component|auto_generated|pll1|inclk[0]}] \
#-offset      $AD9650_output_offset1 \
#-duty_cycle  50/1                   \
#-multiply_by 1                      \
#-master_clock {DCOA} [get_pins {pll_2|altpll_component|auto_generated|pll1|clk[0]}] 


#DCOB_clk
#create_generated_clock -name DCOB_clk -source [get_pins {pll_3|altpll_component|auto_generated|pll1|inclk[0]}] \
#-offset      $AD9650_output_offset2 \
#-duty_cycle  50/1                   \
#-multiply_by 1                      \
#-master_clock {DCOB} [get_pins {pll_3|altpll_component|auto_generated|pll1|clk[0]}] 


#
#
#set_false_path -setup -rise_from [get_clocks clk5_int] -rise_to [get_clocks clk_320MHz_coluta1]
#set_false_path -setup -rise_from [get_clocks clk5_int] -rise_to [get_clocks clk_320MHz_coluta2]
#set_false_path -setup -rise_from [get_clocks clk5_int] -rise_to [get_clocks clk_160MHz_dp_hist]
#set_false_path -setup -rise_from [get_clocks clk5_int] -rise_to [get_clocks clk40]
#set_false_path -setup -rise_from [get_clocks clk5_int] -rise_to [get_clocks clk320_trigger]
#
#

# Automatically constrain PLL and other generated clocks
derive_pll_clocks -create_base_clocks

#determine internal clock uncertainties
derive_clock_uncertainty


