module Altera_10G_TX 
   (
	  
        input clk320,             //main 320MHz clock    

        // Reset
        input rst_txRst_i,
        input rst_rxRst_i,
        
        // Clocks
        output clk_mgtSerialClk_o,// 5.12GHz
        output clk_mgtTxUsrclk_o, // 320MHz
        output clk_mgtRxUsrclk_o, // 320MHz
        
        // PCS Data
        input  wire [31:0]data_txword_i,
        output wire [31:0]data_rxword_o,
        
        // Serial lane
        output ser_tx_o,
        input  ser_rx_i,
        
        // Status
        output sta_mgtTxRdy_o,
        output sta_mgtRxRdy_o,
        
        // Control
        input ctr_clkSlip_i,
        
        // Config
        input wire [7:0]rxPMAInitVal_i // Shall be random value set by a TCL script to make the startup time random
   ); 

wire    pll_powerdown,clk5120,
        pll_10G_locked, pll_cal_busy, 
        tx_ready, rx_ready,
        rx_is_lockedtodata,
        rst, tx_analogreset, tx_digitalreset, rx_analogreset, rx_digitalreset,       
        rx_cal_busy, tx_cal_busy,
		lockedtoref;

reg     rst_s; 
  

assign sta_mgtRxRdy_o     = rx_ready;	
assign sta_mgtTxRdy_o     = tx_ready;
assign rst                = rst_rxRst_i | rst_txRst_i;
assign clk_mgtSerialClk_o = clk5120;


always @(posedge clk320)
 begin
  rst_s          <= rst;
//  sta_mgtRxRdy_o <= rx_ready;	
//  sta_mgtTxRdy_o <= tx_ready;  
 end
 

//10G Transmitter reset circuitry
	TX_10G_reset r0 
   (
		.clock              (clk320),                
		.reset              (rst_s),  
		.pll_powerdown      (pll_powerdown),  
		.tx_analogreset     (tx_analogreset),  
		.tx_digitalreset    (tx_digitalreset),
		.tx_ready           (tx_ready),
		.pll_locked         (pll_10G_locked),
		.pll_select         (1'b0),
		.tx_cal_busy        (pll_cal_busy | tx_cal_busy),  
		.rx_analogreset     (rx_analogreset),  
		.rx_digitalreset    (rx_digitalreset),  
		.rx_ready           (rx_ready),  
		.rx_is_lockedtodata (rx_is_lockedtodata),  
		.rx_cal_busy        (rx_cal_busy) 
   );
	

//PLL system for 10G transmitter
	TX_10G_PLL p1 
   (
		.pll_powerdown (pll_powerdown),  
		.pll_refclk0   (clk320),    
		.tx_serial_clk (clk5120),  
		.pll_locked    (pll_10G_locked),     
		.pll_cal_busy  (pll_cal_busy)
   );
	

//Arria 10 transmitter	
	TX_10G t0 (
		.rx_analogreset     (rx_analogreset),  
		.rx_cal_busy        (rx_cal_busy), 
		.rx_cdr_refclk0     (clk320), 
		.rx_clkout          (clk_mgtRxUsrclk_o), 
		.rx_coreclkin       (clk_mgtRxUsrclk_o), 
		.rx_digitalreset    (rx_digitalreset),            
		.rx_is_lockedtodata (rx_is_lockedtodata), 
		.rx_is_lockedtoref  (lockedtoref), 
		.rx_parallel_data   (data_rxword_o), 
		.rx_pma_clkslip     (ctr_clkSlip_i), 
		.rx_serial_data     (ser_rx_i), 
		
		.tx_analogreset     (tx_analogreset), 
		.tx_cal_busy        (tx_cal_busy), 
		.tx_clkout          (clk_mgtTxUsrclk_o), 
		.tx_coreclkin       (clk_mgtTxUsrclk_o), 
		.tx_digitalreset    (tx_digitalreset), 
		.tx_parallel_data   (data_txword_i), 
		.tx_serial_clk0     (clk5120), 
		.tx_serial_data     (ser_tx_o) 
	);

endmodule
