##
## DEVICE  Arria 10
##


#**************************************************************
# Time Information
#**************************************************************

set_time_format -unit ns -decimal_places 3

#**************************************************************
# Create Clocks
#**************************************************************
create_clock -name {clk40}  -period  25.000 -waveform { 0.000 12.5000 } [get_ports {clk40}]
create_clock -name {clk320} -period   3.125 -waveform { 0.000  1.562  } [get_ports {clk320}]

create_generated_clock -name clk1M     -source [get_nets {p0|iopll_0|altera_iopll_i|twentynm_pll|outclk[1]}] -divide_by 20  -phase 0 [get_pins {pa1|clk1M|q}]
create_generated_clock -name dac_sclk  -source [get_nets {p0|iopll_0|altera_iopll_i|twentynm_pll|outclk[1]}] -divide_by 8   -phase 0 [get_pins {dac1|DAC_SCLK|q}]
#create_generated_clock -name op_starts -source [get_nets {p0|iopll_0|altera_iopll_i|twentynm_pll|outclk[1]}] -divide_by 20  -phase 0 [get_pins {pa1|op_starts|q}]
create_generated_clock -name op_starts -source [get_pins {pa1|clk1M|q}]  -phase 0 [get_pins {pa1|op_starts|q}]

#This is to remove recovery timing errors
set_false_path -from lpgbtFpga_top:f0|Altera_10G_TX:mgt_inst|TX_10G_reset:r0|altera_xcvr_reset_control:xcvr_reset_control_0|alt_xcvr_reset_counter:g_rx.g_rx[0].g_rx.counter_rx_ready|r_reset


# Automatically constrain PLL and other generated clocks
derive_pll_clocks -create_base_clocks

#determine internal clock uncertainties
derive_clock_uncertainty
