//
//module computes the signal pedestal by averaging 
//the signal during last 8 sampling clocks
//
//  jb/october2017/v1.0
//
module pedestal
       (
        input         clk,
        input         valid,
        input   [11:0]in_signal,
        output  [11:0]moving_ped
       );

reg [14:0] in_sum_p1, in_sum_p2, in_sum_p3, in_sum_p4, 
           in_sum_p5, in_sum_p6, in_sum_p7 ;
reg [14:0] in_sum;
reg [11:0] in_p0, in_p1, in_p2, in_p3, in_p4, in_p5, in_p6, in_p7;		  


//
always @(posedge clk)
begin
if (valid)
  begin
    in_p0 <= in_signal; 
    in_p1 <= in_p0;
    in_p2 <= in_p1;
    in_p3 <= in_p2;
    in_p4 <= in_p3;
    in_p5 <= in_p4;
    in_p6 <= in_p5;
    in_p7 <= in_p6;

    in_sum_p1 <= in_p0 + in_p1;
    in_sum_p2 <= in_p2 + in_p3;
    in_sum_p3 <= in_p4 + in_p5;
    in_sum_p4 <= in_p6 + in_p7;

    in_sum_p5 <= in_sum_p1 + in_sum_p2;
    in_sum_p6 <= in_sum_p3 + in_sum_p4;
 
    in_sum_p7 <= in_sum_p5 + in_sum_p6;
  end
end  

assign     moving_ped = in_sum_p7[14:3];

endmodule
