global env ;
transcript on
#delete work lib
#vdel -all

#compile Altera libaries
# Using non-OEM Version, compile all of the libraries
#        vlib lpm_ver
#        vmap lpm_ver lpm_ver 
#        vlog -work lpm_ver $env(QUARTUS_ROOTDIR)/eda/sim_lib/220model.v 

#        vlib altera_mf_ver
#        vmap altera_mf_ver altera_mf_ver
#        vlog -work altera_mf_ver $env(QUARTUS_ROOTDIR)/eda/sim_lib/altera_mf.v

#        vlib altera_prim_ver
#        vmap altera_prim_ver altera_prim_ver
#        vlog -work altera_prim_ver $env(QUARTUS_ROOTDIR)/eda/sim_lib/altera_primitives.v

#        vlib sgate_ver
#        vmap sgate_ver sgate_ver
#        vlog -work sgate_ver $env(QUARTUS_ROOTDIR)/eda/sim_lib/sgate.v

#        vlib cyclone_ver                                                                                      
#        vmap cyclone_ver cyclone_ver                                                                          
#        vlog -work cyclone_ver $env(QUARTUS_ROOTDIR)/eda/sim_lib/cycloneiv_atoms.v    

#        vlib cycloneiv_hssi_atoms
#        vmap cycloneiv_hssi_atoms cycloneiv_hssi_atoms
#        vlog -work cycloneiv_hssi_atoms $env(QUARTUS_ROOTDIR)/eda/sim_lib/cycloneiv_hssi_atoms.v

# Create the libraries
vlib work
vlib tsmc_std_cell
vmap tsmc_std_cell tsmc_std_cell
vlib tsmc_sio
vmap tsmc_sio tsmc_sio

# Now compile the Verilog files one by one 
alias _comp_std {
set simlist [open std_cell_library_list r]
while {[gets $simlist vfile] >= 0} {
vlog  +acc -work tsmc_std_cell $vfile
}
close $simlist
}

alias _comp_short {
set simlist [open short_io_library_list r]
while {[gets $simlist vfile] >= 0} {
vlog  +acc -work tsmc_sio $vfile
}
close $simlist
}

alias _comp {
set simlist [open sim_filelist_functional1] 
while {[gets $simlist vfile] >= 0} {
    vlog  -vlog01compat +acc -work work $vfile
}
close $simlist
}

#_comp_short
#_comp_std
_comp



# Now run the simulation 

vsim -vopt -t ps work.COLUTA_FPGA_tester                       \
     -L tsmc_std_cell -L tsmc_sio                                \
     -L lpm_ver -L altera_mf_ver -L altera_prim_ver -L sgate_ver \
     -L cycloneiv_hssi_atoms -L cyclone_ver                      \
     +transport_int_delays +transport_path_delays                \
     +pulse_r/0 +pulse_e/0 

#allow warnings	 
set NumericStdNoWarnings 0
set StdArithNoWarnings 0
# suppress 3819 
# onbreak { resume }
do wave.do 
view structure
view signals
run -all
